new;
library gdr,,pgraph,optmum;

cls;

datFileName = "..\\data\\data-bonds.dat";
data = loadd(datFileName);

Dates = data[.,1];
R = data[.,2:6];
Sp = data[.,7];
n = rows(R);
R_0 = R[n,.]';
Sp_0 = Sp[n,.];
RR_0 = 0.50;

Notional = 1e6;
P0 =  Risky_Bond_Price(R_0,Sp_0,RR_0,0);

nB = Notional/P0;

dR = R - lag1(R);
dSp = Sp - lag1(Sp);

R = R_0 + dR';
Sp = Sp_0 + dSp';
P =  Risky_Bond_Price(R,Sp,RR_0,1);

PnL = nB * (P - P0);

alpha = 0.99;
hVaR = -quantile(PnL,1-alpha);

print;
print ftos(hVaR,"VaR historique(0.99) = %lf",5,2);

proc (1) = Risky_Bond_Price(R,Spread,RR,h);
  local C,T,S,B,P;

  let C = 5 5 5 5 105;
  let T = 1 2 3 4 5;

  T = T - h/260;

  S = exp(-Spread .* T);
  B = exp(-R .* T);
  P = sumc(C .* B .* S) + RR .* (1 - S[5,.]') .* B[5,.]' .* 100;

  retp(P);
endp;
