new;
library qam,gdr,pgraph,optmum;

cls;

datFileName = "..\\data\\data-bonds.dat";
data = loadd(datFileName);

i = 1;
do until i > 5;

  Dates = data[.,1];
  R = data[.,2:6];
  Sp = data[.,7];
  n = rows(R);
  R_0 = R[n,.]';

  dR = packr(R - lag1(R));

  Sigma = vcx(R);
  __output = 0;

  {va,ve,pca} = regPCA(Sigma,i);
  A = ve * diagrv(eye(i),sqrt(va));

  F = R'/A;
  F = F';
  dF = F - lag1(F);
  delta = dF * A';

  alpha = 0.99;

  let C = 5 5 5 5 105;
  let T = 1 2 3 4 5;
  Notional = 1e6;
  B = exp(-R_0 .* T);
  B = 1 ./ ((1+R_0)^T);

  P0 = sumc(C .* B);
  nB = Notional/P0;

  T = T - 1/260;
  R = R_0 + delta';
  B = exp(-R .* T); 
  B = 1 ./ ((1+R)^T);
  P = sumc(C .* B);
  PnL = nB * (P - P0);

  hVaR = -quantile(PnL,1-alpha);

  print ftos(hVaR,"VaR historique(0.99) = %lf",5,2);

  i = i + 1;
endo;

