new;
library gdr,,pgraph,optmum;

cls;

datFileName = "..\\data\\data-bonds.dat";
data = loadd(datFileName);

Dates = data[.,1];
R = data[.,2:6];
Sp = data[.,7];
n = rows(R);
R_0 = R[n,.]';

graphset;
  begwind;
  window(2,3,1);
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 3; _plwidth = 10; _pcolor = 1;
  _ptitlht = 0.35; _paxht = 0.30; _pnumht = 0.25;

  xtics(0,rows(dates),262/2,2);
  let xlab = "5/07" "11/07"  "5/08" "11/08"  "5/09";
  asclabel(xlab,0);

  ytics(1,6,1,2);
  i = 1;
  do until i > 6;
    if i == 1;
      title("\2161 an");
    elseif i == 2;
      title("\2162 ans");
    elseif i == 3;
      title("\2163 ans");
    elseif i == 4;
      title("\2164 ans");
    elseif i == 5;
      title("\2165 ans");
    elseif i == 6;
      title("\216Spread");
      ytics(0,4,1,2);
    endif;
    setwind(i);
      xy(0,100*data[.,1+i]);
    i = i + 1;
  endo;

  graphprt("-c=1 -cf=var-credit1.eps");

  endwind;


let C = 5 5 5 5 105;
let T = 1 2 3 4 5;
Notional = 1e6;
B =exp(-R_0 .* T);  // B = 1 ./ ((1+R_0)^T);
P0 = sumc(C .* B);
nB = Notional/P0;

D = T;
beta = -C .* D .* B;

dR = packr(R - lag1(R));
Sigma = vcx(dR);
mu = meanc(dR);

vol = sqrt(beta' * Sigma * beta);

alpha = 0.99;
gVaR = nB * (-beta'*mu + cdfni(alpha) * vol);

Results = T~100*R_0~B~C~beta;
let fmt[1,3] = "%lf" 10 3;
call printfm(Results,1,fmt);

T = T - 1/260;
R = R_0 + dR';
B =exp(-R .* T);  // B = 1 ./ ((1+R)^T);
P = sumc(C .* B);
PnL = nB * (P - P0);

hVaR = -quantile(PnL,1-alpha);

print;
print ftos(gVaR,"VaR analytique(0.99) = %lf",5,2);
print ftos(hVaR,"VaR historique(0.99) = %lf",5,2);