new;
library gdr,pgraph,optmum;
gdrSet;

cls;
__output = 0;

declare matrix _order_n,_order_i;
declare matrix _order_mu,_order_sigma,_order_nu,_order_data;

datFileName = "index"; 
data = loadd(datFileName);
vnames = "" $+ getname(datFileName);
let selected_names = date cac djius;
indx = indsav(selected_names,vnames);
data = data[.,indx];

CAC40 = data[.,2];     
r = packr(LogReturn(CAC40,1));

proc cdfProc(x);
  local cdf;
  if _order_nu == 0;
    cdf = cdfn( (x - _order_mu) / _order_sigma );
  else;
    cdf = cdft( (x - _order_mu) / _order_sigma, _order_nu );
  endif;
  retp(cdf);
endp;

proc pdfProc(x);
  local pdf;
  if _order_nu == 0;
    pdf = pdfn( (x - _order_mu) / _order_sigma ) / _order_sigma;
  else;
    pdf = pdft( (x - _order_mu) / _order_sigma, _order_nu ) / _order_sigma;
  endif;
  retp(pdf);
endp;

proc mlProc(theta,data);
  local mu,sigma,pdf;

  _order_mu = theta[1];
  _order_sigma = sqrt(theta[2]^2);

  pdf = pdfOrderStatistic(data,_order_n,_order_i,&cdfProc,&pdfProc);

  retp( ln(missex(pdf,pdf .<= 0) ) );
endp;

fn negLogL(theta) = -sumc(mlProc(theta,_order_data));

let nu = 0 6 1;
nMax = 10;
mu = miss(zeros(nMax,nMax),0);
sigma = miss(zeros(nMax,nMax),0);

k = 1;
do until k > rows(nu);

  _order_nu = nu[k];
  if _order_nu == 0;
    sv = meanc(r)|stdc(r);
  elseif _order_nu <= 2;
    sv = meanc(r)|stdc(r)/sqrt(3); 
  else;
   sv = meanc(r)|stdc(r)/sqrt(_order_nu/(_order_nu-2));
  endif;
  
  n = 1;
  do until n > nMax;
    _order_n = n;
    i = 1;  
    do until i > n; 
      _order_i = i;
 
      str = ftos(_order_nu,"nu = %lf",1,0) $+
            ftos(_order_n,"   --- n = %lf",1,0) $+
            ftos(_order_i,",i = %lf",1,0);
      print /flush str;

      _order_data = OrderData(r,i,n);
      {theta,fmin,grd,retcode} = optmum(&negLogL,sv);

      mu[n,i] = theta[1];
      sigma[n,i] = sqrt(theta[2]^2);

      i = i + 1;
    endo;
    n = n + 1;
  endo;
  call varput(mu,ftos(k,"mu%lf",1,0));
  call varput(sigma,ftos(k,"sigma%lf",1,0));
  k = k + 1;
endo;

output file = stress6.out reset;

print ftosa(1e4*varget("mu1"),"%lf",3,0);
print ftosa(1e4*varget("sigma1"),"%lf",3,0);
print ftosa(1e4*varget("sigma2"),"%lf",3,0);
print ftosa(1e4*varget("sigma3"),"%lf",3,0);

output off;

cls;

print ftosa(1e4*submat(varget("sigma1"),10,0),"%lf",3,1);
print ftosa(1e4*submat(varget("sigma2"),10,0),"%lf",3,1);
print ftosa(1e4*submat(varget("sigma3"),10,0),"%lf",3,1);
