new;
library gdr,pgraph;
gdrSet;

datFileName = "index"; 
data = loadd(datFileName);
vnames = "" $+ getname(datFileName);
let selected_names = date cac djius;
indx = indsav(selected_names,vnames);
data = data[.,indx];

CAC40 = data[.,2]; 

r = packr(LogReturn(CAC40,1));

muG = meanc(r);
sigmaG = stdc(r);

fn cdfProc1(x) = cdfn((x - muG)/sigmaG);
fn pdfProc1(x) = pdfn((x - muG)/sigmaG)/sigmaG;

n = 1~22~262~262*10;
x = seqa(-0.20,0.50/1000,1001);
pdf1 = pdfMaximumStatistic(x,n,&cdfProc1,&pdfProc1);

nu = 3; 
muT = meanc(r);   
sigmaT = stdc(r)/sqrt(nu/(nu-2));

fn cdfProc2(x) = cdft((x - muT)/sigmaT,nu);
fn pdfProc2(x) = pdft((x - muT)/sigmaT,nu)/sigmaT;

pdf2 = pdfMaximumStatistic(x,n,&cdfProc2,&pdfProc2);

nu = 6;
muT = meanc(r);   
sigmaT = stdc(r)/sqrt(nu/(nu-2));

fn cdfProc3(x) = cdft((x - muT)/sigmaT,nu);
fn pdfProc3(x) = pdft((x - muT)/sigmaT,nu)/sigmaT;

pdf3 = pdfMaximumStatistic(x,n,&cdfProc3,&pdfProc3);

graphset;
  begwind;
  window(2,2,0);

  _pframe = 0; _pnum = 2; _pltype = 6|3|1; _plwidth = 10; _pcolor = 2|3|4;
  _pnumht = 0.20; _ptitlht = 0.25; _paxht = 0.25;
  xlabel("\216Rendement du CAC 40");

  setwind(1);
    title("\216Un jour de trading (n=1)");
    xtics(-0.05,0.10,0.05,2);
    ytics(0,50,10,2);
    xy(x,pdf1[.,1]~pdf2[.,1]~pdf3[.,1]);

  setwind(2);
    title("\216Un mois de trading (n=22)");
    xtics(0,0.15,0.05,2);
    ytics(0,60,20,2);
    xy(x,pdf1[.,2]~pdf2[.,2]~pdf3[.,2]);

  setwind(3);
    title("\216Un an de trading (n=262)");
    xtics(0,0.20,0.05,2);
    ytics(0,80,20,2);
    xy(x,pdf1[.,3]~pdf2[.,3]~pdf3[.,3]);

  setwind(4);
    title("\216Dix ans de trading (n=2620)");
    xtics(0,0.25,0.05,2);
    ytics(0,90,30,2);
    _plegstr = "normale\000t]3[\000t]6[";
    _plegctl = {2 6 5 3};
    xy(x,pdf1[.,4]~pdf2[.,4]~pdf3[.,4]);

    graphprt("-c=1 -cf=stress5.eps");

  endwind;

