new;
library gdr,pgraph;
gdrSet;

datFileName = "index"; 
data = loadd(datFileName);
vnames = "" $+ getname(datFileName);
let selected_names = date cac djius;
indx = indsav(selected_names,vnames);
data = data[.,indx];

r = packr(LogReturn(data[.,2 3],1));

mu = meanc(r);
vc = vcx(r);

{mu1,mu2,sigma1,sigma2,rho} = cov2D(mu,vc);

let min = -0.10 -0.10;
{x1,x2,pdf} = Kernel2(r,min,-min,156);

graphset;
  _pdate = ""; _pnum = 2; _pframe = 0;
  volume(2,2,1.5);
  _pzclr = {0 1, 0.00001 2, 1 3, 50 4, 200 4, 500 5, 1000 6,
            1500 7};
  xtics(-10,10,5,2);
  xlabel("\216CAC 40");
  ylabel("\216Dow Jones");
  ytics(-10,10,5,2);
  ztics(0,2000,500,2);
  graphprt("-c=1 -cf=stress3.eps");
  surface(100*x1',100*x2,pdf);

