new;
library gdr,pgraph;
gdrSet;

datFileName = "index"; 
data = loadd(datFileName);
vnames = "" $+ getname(datFileName);
let selected_names = date cac djius;
indx = indsav(selected_names,vnames);
data = data[.,indx];

r = packr(LogReturn(data[.,2 3],1));

mu = meanc(r);
vc = vcx(r);

{mu1,mu2,sigma1,sigma2,rho} = cov2D(mu,vc);

nx = 100;
xmin = -0.10;
x1 = seqa(xmin,-2*xmin/nx,nx+1)';
xmin = -0.10;
x2 = seqa(xmin,-2*xmin/nx,nx+1);
pdf = pdfbvn(x1,x2,mu1,mu2,sigma1,sigma2,rho);

N = 256;

alpha = 0.95;
c = cdfchii(alpha,2);
e1 = InCovarianceEllipse2(r[.,1],r[.,2],mu1,mu2,sigma1,sigma2,rho,c);
{x1,y1} = CovarianceEllipse2(mu1,mu2,sigma1,sigma2,rho,c,N);

alpha = 0.99;
c = cdfchii(alpha,2);
e2 = InCovarianceEllipse2(r[.,1],r[.,2],mu1,mu2,sigma1,sigma2,rho,c);
{x2,y2} = CovarianceEllipse2(mu1,mu2,sigma1,sigma2,rho,c,N);

alpha = 0.99999;
c = cdfchii(alpha,2);
e3 = InCovarianceEllipse2(r[.,1],r[.,2],mu1,mu2,sigma1,sigma2,rho,c);
{x3,y3} = CovarianceEllipse2(mu1,mu2,sigma1,sigma2,rho,c,N);

r = 100*r;
indxIn1 = selif(r,e1);
indxIn2 = selif(r,e1 .xor e2);
indxIn3 = selif(r,e2 .xor e3);
indxOut = delif(r,e3);
sym = indxIn1~(4 ~0.1~2~1~0).*ones(rows(indxIn1),1) |
      indxIn2~(8 ~1.5~3~1~0).*ones(rows(indxIn2),1) |
      indxIn3~(9 ~2.5~4~1~0).*ones(rows(indxIn3),1) |
      indxOut~(10~3.5~5~1~0).*ones(rows(indxOut),1) ;

graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0; _pcross = 1;
  _plctrl = 0|0|0; _pstype = 4;
  _pltype = 6|1|3; _plwidth = 10; _pcolor = 2|4|5;
  xlabel("\216CAC 40");
  ylabel("\216Dow Jones");
  xtics(-10,10,5,2);
  ytics(-10,10,5,2);
  _psym = sym;
  _plegstr = "\202a\201 = 95%\000\202a\201 = 99%\000\202a\201 = 99,999%";
  _plegctl = {2 5 6 0.9};
  graphprt("-c=1 -cf=stress2.eps");
  xy(100*(x1~x2~x3),100*(y1~y2~y3));

