new;
library gdr,pgraph,optmum;
gdrSet;

datFileName = "index"; 
data = loadd(datFileName);
vnames = "" $+ getname(datFileName);
let selected_names = date cac djius;
indx = indsav(selected_names,vnames);
data = data[.,indx];

data = selif(data,data[.,1] .>= 19880101);

rndseed 1234565;

CAC40 = data[.,2];
DJ = data[.,3]; 
y = packr(CAC40~DJ);
r = packr(LogReturn(y,1));

n = 22;       /* one month of trading */

year = seqa(1,1,100);
rt = 250*year; 
alpha = 1 - n/rt;

__output = 0;

ShortStress = zeros(100,2);
LongStress = zeros(100,2);

i = 1;
do until i > 2;

  min = -OrderData(r[.,i],1,n);
  {mu,sigma,xi} = regGEV(min,0);
  LongStress[.,i] = cdfGEVi(alpha,mu,sigma,xi);

  max = OrderData(r[.,i],n,n);
  {mu,sigma,xi} = regGEV(max,0);
  ShortStress[.,i] = cdfGEVi(alpha,mu,sigma,xi);

  i = i + 1;
endo;

let indx = 5 10 25 50 75 100;

output file = stress16.out reset;

call printfm(-100*LongStress[indx,.],1,"%lf"~8~2); print;
call printfm(100*ShortStress[indx,.],1,"%lf"~8~2); print;

output off;

graphset;
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|3; _pstype = 8|9; _plctrl = 10; _pcolor = 2|4;
  _plwidth = 10;
  fonts("simplex simgrma");

  xtics(0,100,10,2);
  ytics(-20,0,5,2);
  xlabel("\216Temps de retour");
  ylabel("\216Echelle de risque (en %)");
  _pmsgstr = "\202\39\201";
  _pmsgctl = 0.31~2.38~0.16~90~2~0~6;
  _plegstr = "CAC 40\000Dow Jones";
  _plegctl = {2 5 6.5 4.5};

  graphprt("-c=1 -cf=stress16.eps");

  xy(year,-100*LongStress);

