new;
library gdr,pgraph,optmum;
gdrSet;

datFileName = "index"; 
data = loadd(datFileName);
vnames = "" $+ getname(datFileName);
let selected_names = date cac djius;
indx = indsav(selected_names,vnames);
data = data[.,indx];

rndseed 123;

CAC40 = data[.,2];
DJ = data[.,3]; 
y = packr(CAC40~DJ);

let Portfolio[4,2] = 1 0 
                     0 1
                     1 1
                     1 -1;
r = packr(LogReturn(y*Portfolio',0));

n = 22;    
let alphaVaR[1,3] = 0.99 0.996 0.999;
rt = 1./(1-alphaVaR);
alphaGEV = 1 - (1./rt*n);

__output = 0;

VaR1 = zeros(4,3);
VaR2 = zeros(4,3);
VaR3 = zeros(4,3);

Pt = 100;

i = 1;
do until i > 4;

  mu = meanc(r[.,i]);
  sigma = stdc(r[.,i]);
  
  VaR1[i,.] = -mu + sigma*cdfni(alphaVaR);      /* Gaussian VaR   */

  VaR2[i,.] = -quantile(r[.,i],1-alphaVaR')';   /* Historical VaR */

  min = -OrderData(r[.,i],1,n);
  {mu,sigma,xi} = regGEV(min,0);
  VaR3[i,.] = cdfGEVi(alphaGEV,mu,sigma,xi);    /* GEV VaR        */

  i = i + 1;
endo;

output file = stress15.out reset;

call printfm(Pt*VaR1,1,"%lf"~8~3); print;
call printfm(Pt*VaR2,1,"%lf"~8~3); print;
call printfm(Pt*VaR3,1,"%lf"~8~3); print;

output off;