new;
library gdr,pgraph,optmum;
gdrSet;

datFileName = "index"; 
data = loadd(datFileName);
vnames = "" $+ getname(datFileName);
let selected_names = date cac djius;
indx = indsav(selected_names,vnames);
data = data[.,indx];

rndseed 123;
r = packr(LogReturn(data[.,2],1));

n = 22;
max = OrderData(r,n,n);
{muGEV22,sigmaGEV22,xiGEV22} = regGEV(max,0);

muG = meanc(r); 
sigmaG = stdc(r);

fn cdfProc(x) = cdfn((x - muG)/sigmaG);
fn pdfProc(x) = pdfn((x - muG)/sigmaG)/sigmaG;

x = seqa(-0.20,0.50/1000,1001);
pdf1 = pdfMaximumStatistic(x,n,&cdfProc,&pdfProc);

pdf2 = pdfGEV(x,muGEV22,sigmaGEV22,xiGEV22);

graphset;
  fonts("simplex simgrma");
  _pframe = 0; _pdate = ""; _pnum = 2;
  _pltype = 6|3; _plwidth = 10; _pcolor = 2|4;
  xtics(0,0.10,0.02,2);
  xlabel("\216x");
  _plegstr = "F]22:22[ (hyp. gaussienne)\000GEV 22 jours de trading";
  _plegctl = {2 5 5 5};
  graphprt("-c=1 -cf=stress14.eps");
  xy(x,pdf1~pdf2);

