new;
library gdr,pgraph;
gdrSet;

datFileName = "index"; 
data = loadd(datFileName);
vnames = "" $+ getname(datFileName);
let selected_names = date cac djius;
indx = indsav(selected_names,vnames);
data = data[.,indx];

r = packr(LogReturn(data[.,2 3],1));

mu = meanc(r);
vc = vcx(r);

{mu1,mu2,sigma1,sigma2,rho} = cov2D(mu,vc);

nx = 100;
xmin = -0.10;
x1 = seqa(xmin,-2*xmin/nx,nx+1)';
xmin = -0.10;
x2 = seqa(xmin,-2*xmin/nx,nx+1);
pdf = pdfbvn(x1,x2,mu1,mu2,sigma1,sigma2,rho);

alpha = 0.9999999;
c = cdfchii(alpha,2);
sym3D = delif(100*r,InCovarianceEllipse2(r[.,1],r[.,2],mu1,mu2,sigma1,sigma2,rho,c));

print rows(r);
print rows(r)*(1-alpha);
print rows(sym3D);

graphset;
  _pdate = ""; _pnum = 2; _pframe = 0;
  volume(2,2,1.5);
  _pzclr = {0 1, 0.00001 2, 1 3, 50 4, 200 5, 500 6, 1000 7,
            1500 8};
  xlabel("\216CAC 40");
  ylabel("\216Dow Jones");
  xtics(-10,10,5,2);
  ytics(-10,10,5,2);
  ztics(0,800,200,2);
  e = ones(rows(sym3D),1);
  _psym3d = sym3D~e.*(0~11~5~0~7);
  graphprt("-c=1 -cf=stress1.eps");
  surface(100*x1,100*x2,pdf);

