new;
library gdr,optmum,pgraph;

Ns = 1e6;
Lambda = 20;
mu = 7;
sigma = 2.5;

L = rndLDA(lambda,mu,sigma,Ns);
CaR = quantile(L,0.999)/1e6;

nR = 250;
new_CaR = zeros(nR,1);

L_new = 100*1e6;

i = 1;
do until i > nR;
  N = Lambda*5;
  L = rndLN(mu,sigma,N,1) | L_new;
  new_mu = meanc(ln(L));
  new_sigma = stdc(ln(L));
  L = rndLDA(lambda,new_mu,new_sigma,Ns);
  new_CaR[i] = quantile(L,0.999)/1e6;
  print /flush ftos(i,"Iteration no. %lf",1,0);
  i = i + 1;
endo;

data = new_CaR ~ (new_CaR./CaR);

_Kernel[1:5] = 0|20|256|6|0;
{x,d,F,retcode} = Kernel(data[.,2]);
d[1] = error(0);

graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; 
  _pframe = 0; _plwidth = 10; _pltype = 6; _pcolor = 5;
  xtics(0,12,2,2);
  _pline = 1~3~1~0~1~1~1~0~10;
  xlabel("\216Ratio CaR]t+1[/CaR]t[");
  graphprt("-c=1 -cf=lda6.eps");
  xy(x,d);

ratio = data[.,2];
let s[1,4] = 1 2 5 10;
Results = meanc(ratio) | meanc(ratio .>= s);
print results;

