new;
library gdr,pgraph;
gdrSet;

lambda = 100;
mu = 9;
sigma = 2;

nobs = 1000; T = 5;

rndseed 123;

nR = 250;
coeffs = zeros(nR,3);

i = 1;
do until i > nR;
  N = rndp(5,1,100);
  coeffs[i,1] = meanc(N);
  L = exp(mu + sigma * rndn(nobs,1) );
  coeffs[i,2] = meanc(ln(L));
  coeffs[i,3] = stdc(ln(L));
  i = i + 1;
endo;

VaR = zeros(nR,3);
nS = 1e6;

i = 1;
do until i > nR;
  L = rndLDA(coeffs[i,1],mu,sigma,Ns);
  VaR[i,1] = quantile(L,0.999);
  L = rndLDA(lambda,coeffs[i,2],coeffs[i,3],Ns);
  VaR[i,2] = quantile(L,0.999);
  L = rndLDA(coeffs[i,1],coeffs[i,2],coeffs[i,3],Ns);
  VaR[i,3] = quantile(L,0.999);
  print /flush ftos(i,"Iteration no. %lf",1,0);
  i = i + 1;
endo;

nS = 1e7;
L = rndLDA(lambda,mu,sigma,Ns);
R = VaR / quantile(L,0.999);

_Kernel[1:3] = 0|2|256;
{x1,d1,F,retcode} = Kernel(R[.,1]);
{x2,d2,F,retcode} = Kernel(R[.,2]);
{x3,d3,F,retcode} = Kernel(R[.,3]);

graphset;
  begwind;
  makewind(9/2,6.855/2,0,6.855/2,0);
  makewind(9/2,6.855/2,9/2,6.855/2,0);
  makewind(9/2,6.855/2,9/4,0,0);
  
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _paxht = 0.25; _pnumht = 0.20; _ptitlht = 0.25;
  _pframe = 0; _plwidth = 10; _pltype = 6;
  xtics(0,2,0.5,2);

  setwind(1);
    title("\216R]Freq[");
    _pcolor = 1;
    xy(x1,d1);

  setwind(2);
    title("\216R]Sev[");
    _pcolor = 2;
    xy(x2,d2);

  setwind(3);
    title("\216R]Freq+Sev[");
    _pcolor = 4;
    xy(x3,d3);

    graphprt("-c=1 -cf=lda3.eps");

  endwind;
 