new;
library gdr,pgraph;
gdrSet;

mu = 8;
sigma = 2.2;
lambda = 50;
Ns = 50000;

nPoisson = seqa(0,1,101);
prPoisson = pdfp(nPoisson,50);

xLN = seqa(-5,0.1,50) | seqa(0.005,0.005,499) | seqa(2.5,0.1,700);
xLN = exp(xLN);
dLN = pdfLN(xLN,mu,sigma);

rndseed 123;
X = rndLDA(lambda,mu,sigma,Ns);
{x,d,f,retcode} = kernel(ln(X));

graphset;
  begwind;
  makewind(9/2,6.855/2,0,6.855/2,0);
  makewind(9/2,6.855/2,9/2,6.855/2,0);
  makewind(9/2,6.855/2,9/4,0,0);
  
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _paxht = 0.25; _pnumht = 0.20; _ptitlht = 0.25;
  _pframe = 0; _plwidth = 10;

  setwind(1);
    title("\216Distribution de la frequence des pertes\201");
    _pmsgstr = "\202\39\201";
    _pmsgctl = 4.8~6.33~0.20~0~2~0~6;
    xtics(0,100,10,0);
    xlabel("\216N(i,j)");
    _pbartyp = { 6 1 };
    bar(nPoisson,prPoisson);

  setwind(2);
    title("\216Distribution de la severite des pertes\201");
    _pmsgstr = "\202\39\201\000\202\39\201\000\202\39\201\000\202\39\201";
    _pmsgctl = 5.2~6.33~0.20~0~2~0~6 |
               5.57~6.33~0.20~0~2~0~6 |
               6.2~6.33~0.20~0~2~0~6 |
               3.57~0.29~0.20~0~2~0~6 ;
    xtics(0,20,5,5);
    _pcolor = 2;
    xlabel("\216\202z\201(i,j) (echelle logarithmique)");
    xy(ln(xLN),dLN);

  setwind(3);
    title("\216Distribution de la perte agregee\201");
    _pmsgstr = "\202\39\201\000\202\39\201";
    _pmsgctl = 6.9~6.33~0.20~0~2~0~6|
               7.33~6.33~0.20~0~2~0~6;
    _pcolor = 4;
    xtics(10,20,2.5,5);
    xlabel("\216ln \202q\201(i,j)");
    xy(x,d);

    graphprt("-c=1 -cf=lda1.eps");

  endwind;

