new;
library gdr,pgraph;
gdrSet;

cls;

proc IRB_RW(LGD,PD,alpha,rho);
  local RW;
  RW = 12.5 * LGD * cdfn( ( cdfni(PD) - cdfni(1-alpha).*sqrt(rho) ) ./ sqrt(1-rho) );
  retp(RW);
endp;

LGD = 0.50;
PD = seqa(0.0,0.001,101);
rho = 0.20;
alpha = 0.90~0.95~0.99~0.995~0.999;
RW = 100*IRB_RW(LGD,PD,alpha,rho);

graphset;
  _pnum = 2; _pframe = 0; _pdate = "";
  _pltype = 6|1|3|6|3;
  _pstype = 8|8|8|8|9;
  _plwidth = 10; _pcolor = 1|2|0|4|5;
  _plctrl = 0|0|0|25|25;
  fonts("simplex simgrma");
  xlabel("\216PD (en %)");
  ylabel("\216RW (en %)");
  xtics(0,10,2,2);
  ytics(0,350,50,2);
  _plegstr = "\202a\201 = 90%\000\202a\201 = 95%\000\202a\201 = 99%\000"\
             "\202a\201 = 99,5%\000\202a\201 = 99,9%";
  _plegctl = { 2 5 2 4.65};
  graphprt("-c=1 -cf=irb7.eps");
  xy(100*PD,RW);