new;
library gdr,pgraph;

rndseed 123;

EAD = 1;
LGD = 0.5;

alpha = 0.90|0.99|0.999;

let N = 50 100 500;
Ns = 5e4;
VaR1 = zeros(rows(alpha),rows(N));
VaR2 = VaR1; RC = VaR1;

format 5,2;

PD = 1000/1e4;
rho = 0.20;
iter = 1;
do until iter > rows(N);
  rndseed 123;
  D = ( sqrt(rho) .* rndn(1,Ns) + sqrt(1-rho) .* rndn(N[iter],Ns) ) .< cdfni(PD);
  L = sumc(EAD .* LGD .* D);
  VaR1[.,iter] = quantile(L,alpha)/N[iter];
  L = sumc(EAD .* rndu(N[iter],Ns) .* D);
  VaR2[.,iter] = quantile(L,alpha)/N[iter];
  RC[.,iter] =  EAD .* LGD .* cdfn( ( cdfni(PD) + cdfni(alpha).*sqrt(rho) ) ./ sqrt(1-rho) );
  iter = iter + 1;
endo;
print 100*(VaR1./RC-1)~100*(VaR2./RC-1);

format 5,2;

PD = 1000/1e4;
rho = 0.10;
iter = 1;
do until iter > rows(N);
  rndseed 123;
  D = ( sqrt(rho) .* rndn(1,Ns) + sqrt(1-rho) .* rndn(N[iter],Ns) ) .< cdfni(PD);
  L = sumc(EAD .* LGD .* D);
  VaR1[.,iter] = quantile(L,alpha)/N[iter];
  L = sumc(EAD .* rndu(N[iter],Ns) .* D);
  VaR2[.,iter] = quantile(L,alpha)/N[iter];
  RC[.,iter] =  EAD .* LGD .* cdfn( ( cdfni(PD) + cdfni(alpha).*sqrt(rho) ) ./ sqrt(1-rho) );
  iter = iter + 1;
endo;
print 100*(VaR1./RC-1)~100*(VaR2./RC-1);

PD = 100/1e4;
rho = 0.20;
iter = 1;
do until iter > rows(N);
  rndseed 123;
  D = ( sqrt(rho) .* rndn(1,Ns) + sqrt(1-rho) .* rndn(N[iter],Ns) ) .< cdfni(PD);
  L = sumc(EAD .* LGD .* D);
  VaR1[.,iter] = quantile(L,alpha)/N[iter];
  L = sumc(EAD .* rndu(N[iter],Ns) .* D);
  VaR2[.,iter] = quantile(L,alpha)/N[iter];
  RC[.,iter] =  EAD .* LGD .* cdfn( ( cdfni(PD) + cdfni(alpha).*sqrt(rho) ) ./ sqrt(1-rho) );
  iter = iter + 1;
endo;
print 100*(VaR1./RC-1)~100*(VaR2./RC-1);

