new;
library gdr,pgraph;

rndseed 123;

EAD = 1;
PD = 1000/1e4;
LGD = 0.5;

alpha = 0.0001|seqa(0.01,0.01,98)|0.999|0.9999;
let N = 5 10 50 500;
Ns = 2e4;
rho = 0.20;

VaR1 = zeros(rows(alpha),4);
VaR2 = VaR1; RC = VaR1;

iter = 1;
do until iter > rows(N);
  rndseed 123;
  D = ( sqrt(rho) .* rndn(1,Ns) + sqrt(1-rho) .* rndn(N[iter],Ns) ) .< cdfni(PD);
  L = sumc(EAD .* LGD .* D);
  VaR1[.,iter] = quantile(L,alpha)/N[iter];
  L = sumc(EAD .* rndu(N[iter],Ns) .* D);
  VaR2[.,iter] = quantile(L,alpha)/N[iter];
  RC[.,iter] =  EAD .* LGD .* cdfn( ( cdfni(PD) + cdfni(alpha).*sqrt(rho) ) ./ sqrt(1-rho) );
  RC[1,iter] = 0.0;
  RC[rows(alpha),iter] = 1.0;
  iter = iter + 1;
endo;

graphset;
  begwind;
  window(2,2,0);

  fonts("simplex simgrma");
  _pnum = 2; _pdate = ""; _pframe = 0;
  _plwidth = 10; _pltype = 6|1|3; _pcolor = 1|2|4;
  _paxht = 0.25; _pnumht = 0.20; _ptitlht = 0.25;

  xtics(0,0.3,0.05,2);
  ytics(0,1,0.2,2);
  xlabel("\216Perte normalisee");
  _pmsgstr = "\202\39\201";
  _pmsgctl = 5.85~0.31~0.15~0~2~0~6;

  iter = 1;
  do until iter > 4;
    setwind(iter);
    title(ftos(N[iter],"\216N = %lf",1,0));
    if iter == 4;
      _plegstr = "Cas granulaire\000Cas non granulaire (LGD = 50%)"\
                 "\000Cas non granulaire (LGD uniforme)";
      _plegctl = {2 5 2.5 2};
    endif;
    xy(RC[.,iter]~VaR1[.,iter]~VaR2[.,iter],alpha);
    iter = iter + 1;
  endo;

  graphprt("-c=1 -cf=irb5.eps");

  endwind;




