new;
library gdr,pgraph;

rndseed 123;

EAD = 1;
PD = 1000/1e4;
LGD = 0.5;

alpha = 0.00001|0.0001|seqa(0.01,0.01,98)|0.9999|0.999999;

N = 50;
rho = 0.0~0.20~0.50;

RC = N * EAD .* LGD .* cdfn( ( cdfni(PD) + cdfni(alpha).*sqrt(rho) ) ./ sqrt(1-rho) );
RC[1,1] = 0.0;
RC[rows(alpha),1] = 100.0;

X = seqa(-4.0,7/100,101);
EL = N * EAD .* LGD .* cdfn( ( cdfni(PD) - X .* sqrt(rho) ) ./ sqrt(1-rho) );

graphset;
  begwind;
  makewind(9,6.855,0,0,1);
  makewind(4,3,4.75,1.75,1);
  makewind(2.75,2,6.25,3.25,1);

  fonts("simplex simgrma");
  _pnum = 2; _pdate = ""; _pframe = 0;
  _plwidth = 10; _pltype = 6|1|3|2; _pcolor = 1|2|4;

  setwind(1);
    xlabel("\216Perte");
    ylabel("\216CDF");
    ytics(0,1,0.2,1);
    xtics(0,8,1,2); 
    _plegstr = "\202r\201 = 0%\000\202r\201 = 20%\000\202r\201 = 50%";
    _plegctl = {2 5 1.35 5.5};
    xy(RC,alpha);

  setwind(2);
    _paxht = 0.25; _pnumht = 0.30; _plwidth = 10;
    xtics(-4,3,1,2);
    ytics(0,25,5,2);
    xlabel("\216Facteur X");
    ylabel("\216E\202\34\201L | X\202v\201");
    _plegctl = 0;
    xy(X,EL);

  setwind(3);
    _paxht = 0.35; _pnumht = 0.25; _plwidth = 10; _pltype = 4;
    xtics(-4,3,1,2);
    ytics(0,0.4,0.1,2);
    xlabel("\216X");
    ylabel("\216PDF");
    _plegctl = 0;
    xy(X,pdfn(X));

    graphprt("-c=1 -cf=irb4.eps");

  endwind;
