new;
library gdr,pgraph;
gdrSet;

datFileName = "index"; 
data = loadd(datFileName);
vnames = "" $+ getname(datFileName);

let selected_names = date sp djes topix em;

indx = indsav(selected_names,vnames);
data = data[.,indx];
data = selif(data,data[.,1] .>= 19950101);

Dates = data[.,1];
x = data[.,2:5];

{t,L1} = Stress_Function(x,260,1);
{t,L2} = Stress_Function(x,260,2);

p = 1e-3;

L1s = L1;
L2s = L2;
i = 1;
do until i > cols(L1);
  L1s[.,i] = fspline(csspline(t,L1[.,i],1,p),t);
  L2s[.,i] = fspline(csspline(t,L2[.,i],1,p),t);
  i = i + 1;
endo;

graphset; 
  begwind;
  makewind(9,6.855,0,0,1);
  makewind(9,6.855,0,0,1);

  _pdate = ""; _pnum = 2; _pframe = 0; _pcross = 0;
  xtics(1,12*21,21,2);
  let xlab = "" "1M" "2M" "3M" "4M" "5M" "6M" "7M" "8M" "9M" "10M" "11M" "12M";
  asclabel(xlab,0);
  _plwidth = 10; _pcolor = 1|4; _pltype = 6|3;
  _pline = 1~6~0~0~5000~0~1~0~10;
  ytics(-60,90,30,2);
  fonts("simplex simgrma");

  setwind(1);
    xlabel("\216\202D\201t");
    xy(t,100*L1s[.,1 4]);

  setwind(2);
    _plegstr = "S&P 500\000MSCI EM";
    _plegctl = {2 5 1.5 5.5};
    xy(t,100*L2s[.,1 4]);

    graphprt("-c=1 -cf=hstress1.eps");

  endwind;

indx = 1|5|20|60;
Results = (L1[indx,.]~L2[indx,.]);

let fmt[1,3] = "%lf" 10 1;
call printfm(100*Results,1,fmt);