new;

#ifdef USE_OPTMUM
  library option,pgraph,optmum;
#else
  library option,pgraph;
#endif

optionSet;

cls;

F0 = 0.05;
tau = 1;

N = 101;
K = seqa(0.02,0.001,N);

let Strike = 0.03 0.04 0.05 0.07;
let ImpVol = 0.13 0.10 0.09 0.10;

{alpha1,beta1,nu1,rho1} = SABR_Calibrate(F0,Strike,ImpVol,0,tau,0);
{alpha2,beta2,nu2,rho2} = SABR_Calibrate(F0,Strike,ImpVol,0.5,tau,0);
{alpha3,beta3,nu3,rho3} = SABR_Calibrate(F0,Strike,ImpVol,1.0,tau,0);

results = alpha1~beta1~nu1~rho1|
          alpha2~beta2~nu2~rho2|
          alpha3~beta3~nu3~rho3;
let fmt[1,3] = "%lf" 10 3;
call printfm(results,1,fmt);

ImpVol_K = SABR_ImpVol(F0,K,alpha1,beta1,nu1,rho1,tau) ~ 
           SABR_ImpVol(F0,K,alpha1,beta1,nu1,rho1,tau) ~ 
           SABR_ImpVol(F0,K,alpha1,beta1,nu1,rho1,tau) ;

graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|3|1; _plwidth = 10; _pcolor = 4;
  ylabel("\216\202S\201(T,K) (en %)");
  xlabel("\216K (en %)"); 
  xtics(2,8,1,2);
  _psym = 100*strike~100*ImpVol~ones(4,1).*(11~6.5~0~1~10);
  ytics(8,16,2,2);
  graphprt("-c=1 -cf=hedging9.eps");
  xy(100*K,100*ImpVol_K);

