new;

#ifdef USE_OPTMUM
  library option,pgraph,optmum;
#else
  library option,pgraph;
#endif

optionSet;

cls;

F0 = 0.05;
tau = 1;

N = 41;
K = seqa(0.02,0.001,N) ~ seqa(0.03,0.001,N) ~ seqa(0.04,0.001,N);
K = K + 0.0001;
K_BB = seqa(0.02,0.001,N+30);

let Strike = 0.04 0.05 0.06;
let ImpVol = 0.11 0.09 0.10;

{alpha1,beta1,nu1,rho1} = SABR_Calibrate(F0,Strike,ImpVol,1,tau,0);
{alpha2,beta2,nu2,rho2} = SABR_Calibrate(F0,Strike,ImpVol,0,tau,0);
{alpha3,beta3,nu3,rho3} = SABR_Calibrate(F0,Strike,ImpVol,0.5,tau,0);

let F0 = 0.04 0.05 0.06;

ImpVol1 = SABR_ImpVol(F0[1],K[.,1],alpha1,beta1,nu1,rho1,tau) ~ 
          SABR_ImpVol(F0[2],K[.,2],alpha1,beta1,nu1,rho1,tau) ~ 
          SABR_ImpVol(F0[3],K[.,3],alpha1,beta1,nu1,rho1,tau) ;

BackBone1 = SABR_ImpVol(K_BB,K_BB,alpha1,beta1,nu1,rho1,tau);
 
ImpVol2 = SABR_ImpVol(F0[1],K[.,1],alpha2,beta2,nu2,rho2,tau) ~ 
          SABR_ImpVol(F0[2],K[.,2],alpha2,beta2,nu2,rho2,tau) ~ 
          SABR_ImpVol(F0[3],K[.,3],alpha2,beta2,nu2,rho2,tau) ;

BackBone2 = SABR_ImpVol(K_BB,K_BB,alpha2,beta2,nu2,rho2,tau);
BackBone3 = SABR_ImpVol(K_BB,K_BB,alpha3,beta3,nu3,rho3,tau);

graphset;
  begwind;
  makewind(9/2,6.855/2,0,6.855/2,1);
  makewind(9/2,6.855/2,9/2,6.855/2,1);
  makewind(9/2,6.855/2,9/4,0,1);

  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|3|1; _plwidth = 10; _pcolor = 1|2|4;
  _paxht = 0.22; _pnumht = 0.20; _ptitlht = 0.22;
  ylabel("\216\202S\201(T,K) (en %)");
  xlabel("\216K (en %)"); 
  xtics(2,8,1,2);

  setwind(1);
    title("\216\202b\201 = 1");
    _parrow = 5~8.5~4~8.5~2~0.20~01~3~1~6~10 | 
              5~8.5~6~8.5~2~0.20~01~3~1~6~10;
    _pline = 1~6~5~8.25~5~8.75~1~3~10;
    ytics(8,16,2,2);
    xy(100*K,100*ImpVol1);

  setwind(2);
    title("\216\202b\201 = 0");
    _parrow = 5~8.0~4~9.5~2~0.20~01~3~1~6~10 | 
              5~8.0~6~6.5~2~0.20~01~3~1~6~10;
    _pline = 1~6~5~7.75~5~8.25~1~3~10;
    ytics(6,21,3,2);
    xy(100*K,100*ImpVol2);

  setwind(3);
    title("\216Backbone");
    ytics(6,14,2,2);
    _parrow = 0; _pline = 0;
    _plegstr = "\202b\201 = 1\000\202b\201 = 0\000\202b\201 = 0,5";
    _plegctl = {2 6 6 4};
    xy(100*K_BB,100*(BackBone1~BackBone2~BackBone3));

    graphprt("-c=1 -cf=hedging7.eps");

  endwind;
