new;
library option,pgraph;
optionSet;

cls;

S0 = 100;
tau = 1/12;
r = 0.05;
sigma =  0.20;
 
V0 = 0.2^2; 

theta = V0; 
Kappa = 0.5; 
sigmaV = 0.9; 
lambda = 0;  

K = seqa(85,1,31);
nK = rows(K);

rho = seqa(-0.5,0.25,5);
nRho = rows(rho);

ImpVol = zeros(nK,nRho);

_int_order = 128;
_int_mtd = 2;

i = 1;
do until i > nRho;
  ImpVol[.,i] = EuropeanHeston_ImpVol(S0,K,tau,r,V0,kappa,theta,sigmaV,rho[i],lambda);
  i = i + 1;
endo;  

graphset;
  _pdate = ""; _pnum = 2; _pframe = 0; _plwidth = 10;
  _pltype = 3|1|6|1|3;
  _pstype = 8|8|10|9|9;
  _plctrl = 2|2|0|2|2;
  _pcolor = 1|2|3|4|5|6;
  fonts("simplex simgrma");
  xtics(85,115,5,5);
  xlabel("\216K");
  _plegstr = "\202r\201 = -0,5\000\202r\201 = -0,25\000\202r\201 = 0"\
             "\000\202r\201 = 0,25\000\202r\201 = 0,5"; 
  _plegctl = {2 5 4 4.5};
  graphprt("-c=1 -cf=hedging6.eps");     
  xy(K,100*ImpVol); 
