/*
**> In this program, we compute the local volatility from the implied volatility
** 
*/

new;
library option,pgraph;
OptionSet;

cls;

let Smile_K      = 80   85   90   95   100  105  110   115  120;
let Smile_ImpVol = 0.23 0.22 0.21 0.20 0.19 0.20 0.21 0.22 0.23;

S0 = 100;
r = 0.05;
b = 0.05;

declare matrix p_smoothing;

proc SigmaSurface(T,K);
 local r,c,d,smile,i;
 r = _max_(rows(T),rows(K));
 c = _max_(cols(T),cols(K));
 smile = zeros(r,c);
 i =  1;
 do until i > c;
   d = 0.025*T[i];
   Smile[.,i] = fspline(csspline(Smile_K,(1 + 1.25*T[i]) * (Smile_ImpVol - 0.19) + 0.19 + d,1,p_smoothing),K);
   i = i + 1;
 endo;
 retp(Smile);   /* Cubic Spline Smoothing */
endp;

p_smoothing = 0.25;
K = seqa(70,1,61);

T = seqa(0,1/12/10,10*12+1)';
ImpVol = SigmaSurface(t,K);
LocalVol = ImpVol_to_LocalVol(&SigmaSurface,0,0,0,T,K,S0,b);

indx = 13|73|121;

pqgwin many;

graphset;
  begwind;
  makewind(9,6.855,0,0,1);
  makewind(9/3,6.855/3,5.75,3.75,0);

  fonts("simplex simgrma");

  _pdate = ""; _pnum = 2; _pframe = 0;
  xtics(70,130,10,2);

  setwind(1);
    _pzclr = seqa(1,1,7);
    ytics(0,1,0.20,2);
    xlabel("\216S");
    ylabel("\216t");
    title("\216\202s\201(t,S) (en %)");
    surface(K',T',100*LocalVol');

  setwind(2);
    _pbox = 1; _paxht = 0.30; _pnumht = 0.30; _ptitlht = 0.30;
    ytics(15,40,5,2); _pltype = 6|1|3; _pcolor = 1|2|3|4|5|6; _plwidth = 10;
    xlabel("\216K"); ylabel("");
    title("\216\202S\201(T,K) (en %)");
    _plegstr = "T = 1M\000T = 6M\000T = 12M";
    _plegctl = {2 5 5 4};
    xy(K,100*ImpVol[.,indx]);

    graphprt("-c=1 -cf=hedging5.eps");

  endwind;

//_pqg_ps_Monochrome = 1;
tkf2eps("graphic.tkf", "test.eps");



