new;
library option,pgraph;
dlibrary option_tridiag; // Don't miss to download the tridiag solver or use the procedure OptionSet

cls;
declare matrix K;

let Strike = 80 85 90 95 100 105 110 115 120;
sigma = 0.20;
r = 0.05;
b = 0.02;

L = 85;
H = 110;

let S0_ = 50 70 85 100 115 130 150;
let ImpVol_ = 0.24 0.22 0.21 0.18 0.20 0.20 0.20;

fileName = "tmp";
xmin = 0; xmax = 200; Nx = 1001;
tmin = 0; tmax = 0.5; Nt = 2501;

_PDE_SaveLastIter = 0;
_PDE_PrintIters = 50;
__output = 1;

S = 100;
tau = seqa(0.10,0.05,9);

{t,x,k_,h_,r_} = PDE_GetMesh(tmin,tmax,Nt,xmin,xmax,Nx);

_fcmptol = 1e-12;
indx_S = FindIndex(x,S);
S = x[indx_S]; 
indx_tau = FindIndex(t,tau);
tau = t[indx_tau]; tau = tau';

/*
**> Volatility Smile
**
*/

proc SigmaSurface(t,S);
 retp(fspline(csspline(S0_,ImpVol_,1,0.5),S));   /* Cubic Spline Interpolation */
endp;

proc aProc(t,x);
  retp( 0.5*(SigmaSurface(t,x)^2) .* (x^2) );
endp;

proc bProc(t,x);
  retp( b .* x );
endp;

proc cProc(t,x);
  retp( r .* ones(rows(x),1) );
endp;

proc dProc(t,x);
  retp( zeros(rows(x),1) );
endp;

/*
**> With a variational inequality
*/

proc eProc(t,x,U);
  local cnd1,cnd2,cnd;
  
  cnd1 = x .> L;      /* Down barrier of the KOC option */
  cnd2 = x .< H;      /* Up barrier of the KOC option */

  cnd = cnd1 .and cnd2;

  retp( cnd .* U );
endp;

proc tminBound(t,x);
  local PayOff;

  PayOff = EuropeanPayOff(x,K);

  retp( PayOff );
endp;

proc tminBound_KOC(t,x);
  local PayOff,cnd1,cnd2,cnd;
  
  cnd1 = x .> L;      /* Down barrier of the KOC option */
  cnd2 = x .< H;      /* Up barrier of the KOC option */

  cnd = cnd1 .and cnd2;

  PayOff = EuropeanPayOff(x,K);

  retp( cnd .* PayOff );
endp;

proc xminBound(t,x);
  retp( zeros(rows(x),1) );
endp;

proc DxmaxBound(t,x);
  retp( ones(rows(x),1) );
endp;

ImpVol = zeros(rows(Strike),cols(tau));
KOC = zeros(rows(Strike),cols(tau));

j = 1;
do until j > rows(Strike);

  cls;
  print /flush j;
  print;

  K = Strike[j];

  /* European Option */

  call PDE(&aProc,&bProc,&cProc,&dProc,0,&tminBound,&xminBound,0,0,&DxmaxBound);
  call PDE_solve(tmin,tmax,Nt,xmin,xmax,Nx,fileName,0.5);

  U = zeros(rows(S),cols(tau));
  i = 1;
  do until i > cols(tau);
    U[.,i] = submat(PDE_readFile(fileName,"t"|tau[1,i]),indx_S,0);
    ImpVol[j,i] = EuropeanBS_ImpVol(S,K,tau[1,i],b,r,U[.,i]);
    i = i + 1;
  endo;

  /* KOC option */

  call PDE(&aProc,&bProc,&cProc,&dProc,&eProc,&tminBound_KOC,&xminBound,&xminBound,0,0);
  call PDE_solve(tmin,tmax,Nt,xmin,xmax,Nx,fileName,0.5);

  U = zeros(rows(S),cols(tau));
  i = 1;
  do until i > cols(tau);
    U[.,i] = submat(PDE_readFile(fileName,"t"|tau[1,i]),indx_S,0);
    KOC[j,i] = U[.,i];
    i = i + 1;
  endo;

  j = j + 1;
endo;

call DeleteFile(fileName $+ ".dat");

graphset;
  begwind;
  window(2,3,0);
  makewind(9,6.855,0,0,1);

  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pnumht = 0.25; _paxht = 0.25; _ptitlht = 0.32;
  _plwidth = 10;

  setwind(1);
    _pcolor = 2;
    title("\216Volatilite locale");
    xlabel("\216S");
    ylabel("\216\202s\201(t,S)");
    ytics(0.18,0.22,0.010,2);
    xy(seqa(80,1,41),SigmaSurface(0,seqa(80,1,41)));

  xlabel("\216T");
  ylabel("\216K");
  xtics(0.10,0.50,0.10,2); ytics(80,120,10,2);

  _pzclr = 1;

  setwind(2);
  
    title("\216Volatilite implicite \202S\201(T,K)");
    ztics(0.18,0.20,0.01,2); 
    surface(tau,Strike,ImpVol);

  setwind(3);

    title("\216Prix de l'option KOC");
    ztics(0,16,4,2); 
    surface(tau,Strike,KOC);

  setwind(4);

    title("\216Difference avec BS\L\216\202S\201 = 18%");
    ztics(-0.30,0,0.10,2); 
    KOC2 = EuropeanBS_KOC(S,Strike,0.18,tau,b,r,tau,L,H);
    surface(tau,Strike,KOC-KOC2);

  setwind(5);

    title("\216Difference avec BS\L\216\202S\201 = 20%");
    ztics(0,1.5,0.5,2); 
    KOC3 = EuropeanBS_KOC(S,Strike,0.20,tau,b,r,tau,L,H);
    surface(tau,Strike,KOC-KOC3);

  setwind(6);

    title("\216Difference avec BS\L\216\202S\201 = \202S\201(T,K)");
    KOC4 = EuropeanBS_KOC(S,Strike,ImpVol,tau,b,r,tau,L,H);
    surface(tau,Strike,KOC-KOC4);

  setwind(7);
    _paxes = 0; _ptitle = 0; xlabel(""); ylabel("");
    _pmsgstr = "\202\39\201\000\202\39\201\000\202\39\201\000\202\39\201\000\202\39\201\000";
    _pmsgctl = 1.66~6.63~0.10~0~2~0~5.5 |
               4.18~6.59~0.10~0~2~0~5.5 |
               1.10~3.16~0.10~0~2~0~5.5 |
               4.10~3.16~0.10~0~2~0~5.5 |
               7.10~3.16~0.10~0~2~0~5.5 ;
    draw;

    graphprt("-c=1 -cf=hedging4.eps");
  
  endwind;

