new;
library qam,pgraph,optmum,option;

cls;

// fn sumr(x) = sumc(x');

Notional = 100;
S0 = 98; mu = 0.10; sigma = 0.20;
tau = 130/260;
r = 0.05;
b = r;
K = 100;
C0 = EuropeanBS(S0,K,sigma,tau,r,r);

Ns = 10000;

sigma = 0.20;

fn Premium_Proc(t,St,rt) = EuropeanBS(St,K,sigma,tau-t,rt,rt);
fn Delta_Proc(t,St,rt) = EuropeanBS_Delta(St,K,sigma,tau-t,rt,rt);

let dt = 1;
PnL_Ratio = zeros(Ns,3);
t = seqa(0,dt/260,130/dt+1);

St = Simulate_GBM(S0,mu,sigma,t,Ns);
{Dynamic_Hedging,PnL,PnL_Option,PnL_Hedging,Results} = Compute_Dynamic_Delta_Hedging(Notional,C0,&Premium_Proc,&Delta_Proc,t,St,r,0);
PnL_Ratio[.,1] = PnL' / (Notional * C0);

sigma = 0.30;
St = Simulate_GBM(S0,mu,sigma,t,Ns);
{Dynamic_Hedging,PnL,PnL_Option,PnL_Hedging,Results} = Compute_Dynamic_Delta_Hedging(Notional,C0,&Premium_Proc,&Delta_Proc,t,St,r,0);
PnL_Ratio[.,2] = PnL' / (Notional * C0);

let Strike = 98 100 102;
let ImpVol = 0.20 0.18 0.20;
{alpha,beta,nu,rho} = SABR_Calibrate(S0,Strike,ImpVol,1,tau,0);

alpha = 0.20; beta = 1; nu = 0.25; rho = -0.5;

fn procMu1(t,x1,x2) = mu * x1;
fn procMu2(t,x1,x2) = 0.0;
fn procSigma11(t,x1,x2) = x2 .* x1;
fn procSigma12(t,x1,x2) = 0.0;
fn procSigma21(t,x1,x2) = 0.0;
fn procSigma22(t,x1,x2) = nu * x2^beta;

{St,sigmat} = qmc_simulate_SDE2(S0,alpha,&procMu1,&procMu2,
           &procSigma11,&procSigma12,&procSigma21,&procSigma22,rho,t,Ns);

{Dynamic_Hedging,PnL,PnL_Option,PnL_Hedging,Results} = Compute_Dynamic_Delta_Hedging(Notional,C0,&Premium_Proc,&Delta_Proc,t,St,r,0);
PnL_Ratio[.,3] = PnL' / (Notional * C0);

x = seqa(-1.00,2.00/255,256);

d = zeros(256,cols(PnL_Ratio));
i = 1;
do until i > cols(d);
  {d[.,i],F} = regKernelDensity(PnL_Ratio[.,i],x);
  i = i + 1;
endo;
  
graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|3|1; _plwidth = 10; _pcolor = 1|2|3|4|5|6; 
  _pstype = 8|8|8|8|9; _plctrl = 0|0|0|15|15;
  xtics(-80,60,20,2);
  xlabel("\216Ratio \202p\201 (en %)");
  _plegstr = "\202s\201 = 20%\000\202s\201 = 30%\000SABR";
  _plegctl = {2 5 6.5 4};
  graphprt("-c=1 -cf=hedging3.eps");
  xy(100*x,d);