new;
library qam,pgraph,optmum,option;

cls;

Notional = 100;
S0 = 98; mu = 0.05; sigma = 0.20;
tau = 130/260;
r = 0.05;
b = r;
K = 100;
C0 = EuropeanBS(S0,K,sigma,tau,r,r);

Ns = 10000;

sigma = 0.20;

fn Premium_Proc(t,St,rt) = EuropeanBS(St,K,sigma,tau-t,rt,rt);
fn Delta_Proc(t,St,rt) = EuropeanBS_Delta(St,K,sigma,tau-t,rt,rt);

let dt = 26 13 10 5 2 1 0.5 0.25 0.125 0.0625;
PnL_Ratio = zeros(Ns,rows(dt));
i = 1;
do until i > rows(dt);
  t = seqa(0,dt[i]/260,130/dt[i]+1);
  St = Simulate_GBM(S0,mu,sigma,t,Ns);
  {Dynamic_Hedging,PnL,PnL_Option,PnL_Hedging,Results} = Compute_Dynamic_Delta_Hedging(Notional,C0,&Premium_Proc,&Delta_Proc,t,St,r,0);
  PnL_Ratio[.,i] = PnL' / (Notional * C0);
  i = i + 1;
endo;

Hedge_Efficiency = stdc(PnL_Ratio) | 0;
dt = dt |0;

x = seqa(0,0.1,300);
y = fspline(csspline(rev(dt),rev(Hedge_Efficiency),1,0.99),x);
  
graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6; _plwidth = 10; _pcolor = 1;
  xtics(0,25,5,5);
  ytics(0,0.35,0.05,5);
  xlabel("\216dt (en jours)");
  graphprt("-c=1 -cf=hedging2.eps");
  xy(x,y);
