/*
**> Converts a smile curve into a pdf
**
*/

new;
library option,pgraph;

S0 = 100;
tau = 10;
r = 0.05;

Sk = 90;
//fn smile(K) = 0.25 + (5e-6*(K-Sk)^2) .* (K .<= Sk) + (5e-6*((K-Sk)^2)^0.75) .* (K .> Sk);
fn smile(K) = 0.25 + ln ( 1 + 1e-6 * (K-90)^2 + 1e-6*(K-180)^2 );

K = seqa(1,3,100);

{Sigma,CDF,PDF} = Smile_to_Density(S0,K,&smile,tau,r);

{cdf_ln,pdf_ln} = EuropeanBS_Density(S0,K,0.25,tau,r);

graphset;
  begwind;
  makewind(9/2,6.855/2,9/4,6.855/2,1);
  makewind(9/2,6.855/2,0,0,1);
  makewind(9/2,6.855/2,9/2,0,1);

  _pltype = 6|3; _pframe = 0; _pnum = 2;
  _paxht = 0.25; _pnumht = 0.20; _ptitlht = 0.25;
  _pcolor = 1|4; _plwidth = 10; _pltype = 6|3;
  xtics(0,300,50,5);
  xlabel("\216K");

setwind(1);
  title("\216SMILE");
  ytics(0.25,0.28,0.01,2);
  xy(K,sigma);

  xlabel("\216x");

setwind(2);
  title("\216CDF");
  ytics(0,1,0.2,2);
  xy(K,cdf~cdf_ln);

setwind(3);
  title("\216PDF");
  ytics(0,7e-3,1e-3,2);
  _plegstr = "Smile\000Black-Scholes ATM";
  _plegctl = {2 5 5 5};
  xy(K,pdf~pdf_ln);

  graphprt("-c=1 -cf=hedging12.eps");

endwind;