new;
library pgraph;

proc SABR_Stdiv(alpha,beta,nu,rho,tau);
  local s;

  if beta == 0;
    s = alpha .* sqrt(exp(nu^2 .* tau) - 1.0) ./ nu ;
  else;
    s = error(0);
  endif;

  retp(s);
endp;

proc SABR_Moment2(alpha,beta,nu,rho,tau);
  local m2;

  if beta == 0;
    m2 = alpha^2 ./ nu^2 .* (exp(nu^2 .* tau) - 1.0);
  else;
    m2 = error(0);
  endif;

  retp(m2);
endp;

proc SABR_Moment3(alpha,beta,nu,rho,tau);
  local m3;

  if beta == 0;
    m3 = alpha^3 ./ nu^3 .* rho .* (exp(3*nu^2 .* tau) - 3 * exp(nu^2 .* tau) + 2.0) ;
  else;
    m3 = error(0);
  endif;

  retp(m3);
endp;

proc SABR_Moment4(alpha,beta,nu,rho,tau);
  local m4;

  if beta == 0;
    m4 = alpha^4 ./ nu^4 .* ( (4*rho^2+1)/5 .* exp(6*nu^2 .* tau) - 
                              4 * rho^2 .* exp(3 * nu^2 .* tau) +
                              6/5 * (6*rho^2-1) .* exp(nu^2 .* tau) + 
                              1 - 4* rho^2 );
  else;
    m4 = error(0);
  endif;

  retp(m4);
endp;

proc SABR_Skewness(alpha,beta,nu,rho,tau);
  local sk;

  sk = SABR_Moment3(alpha,beta,nu,rho,tau) ./ SABR_Stdiv(alpha,beta,nu,rho,tau)^3;

  retp(sk);
endp;

proc SABR_Kurtosis(alpha,beta,nu,rho,tau);
  local kt;

  kt = SABR_Moment4(alpha,beta,nu,rho,tau) ./ SABR_Stdiv(alpha,beta,nu,rho,tau)^4;

  retp(kt);
endp;

alpha = 0.20;
beta = 0;
rho = 0~0.5~1.0;
nu = 0.01|0.10|0.25|0.50|1.0;
tau = 1.0;
k1 = SABR_Kurtosis(alpha,beta,nu,rho,tau);
tau = 2;
k2 = SABR_Kurtosis(alpha,beta,nu,rho,tau);

results = k1~k2;
let fmt[1,3] = "%lf" 10 2;
call printfm(results,1,fmt);
