/*
**> In this example, we analyze the derivative d(ImpVol)/d(ATM) in the SABR model
**  for several values of beta
**
*/

new;

#define USE_OPTMUM

#ifdef USE_OPTMUM
  library option,pgraph,optmum;
#else
  library option,pgraph;
#endif

optionSet;
cls;
__output = 0;

let tau = 12;
tau = tau / 12;

// First, we transform the Normal SABR parametrization into Black volatilty smile

let params = 0.00895 0.00 0.57 0.23;
alpha = params[1]; beta = params[2]; nu = params[3]; rho = params[4];
F0 = 0.05;
let Strike = 0.03 0.04 0.05 0.06 0.07;
Smile = SABR_ImpVol_Normal(F0,Strike,alpha,beta,nu,rho,tau);
ImpVol = ImpVol_Normal_2_LN(F0,Strike,Smile,tau);                      // BS smile

let beta = 0 1;
K = seqa(0.01,0.09/100,101);
nBeta = rows(beta); nK = rows(K);
Smile = zeros(nK,nBeta);
VegaBS = zeros(nK,nBeta); VegaATM = zeros(nK,nBeta);
DeltaBS = zeros(nK,nBeta); Delta1 = zeros(nK,nBeta); Delta2 = zeros(nK,nBeta);

_sabr_shift_Vega = 0.001;   // Shift on the ATM volatility for computing the Vega in the SABR model
_sabr_shift_Delta = 0.001;  // Shift on the ATM volatility for computing the Delta in the SABR model

i = 1;
do until i > rows(beta);
  {alpha,beta[i],nu,rho} = SABR_Calibrate(F0,Strike,ImpVol,beta[i],tau,0);
  Smile[.,i] = SABR_ImpVol(F0,K,alpha,beta[i],nu,rho,tau);
  {vegaBS[.,i],vegaATM[.,i]} = sabr_vega(F0,K,alpha,beta[i],nu,rho,tau);
  {DeltaBS[.,i],Delta1[.,i],Delta2[.,i]} = sabr_delta(F0,K,alpha,beta[i],nu,rho,tau);
  i = i + 1;
endo;

graphset;
  begwind;
  makewind(9/2,6.855/2,0,6.855/2,1);
  makewind(9/2,6.855/2,9/2,6.855/2,1);
  makewind(9/2,6.855/2,9/4,0,1);

    fonts("simplex simgrma");
    _pdate = ""; _pnum = 2; _pframe = 0;
    _plwidth = 10;
    _pnumht = 0.22; _paxht = 0.22; _ptitlht = 0.25;
    _pltype = 6|3|1; _pcolor = 4|1|5;
    xlabel("\216K (en %)");

  setwind(1);
    title("\216Smile (en %)");
    ytics(15,40,5,2);
    xy(100*K,100*Smile[.,1]);   

  setwind(2);
    title("\216Vega (en pb)");
    ytics(0,0.20,0.05,2);
    _plegstr = "BS\000SABR ATM (\202b\201 = 0)\000SABR ATM (\202b\201 = 1)";
    _plegctl = {2 5 0 4};
    _pmsgstr = "\202\39\201";
    _pmsgctl = 3.82~6.38~0.15~0~2~0~8 ;
    xy(100*K,1e4*(VegaBS[.,1]~VegaATM));

    _pmsgctl = 0;

  setwind(3);
    title("\216Delta (en %)");
    ytics(0,100,20,2);
    _plegctl = {2 5 6 4};
    _plegstr = "BS\000SABR\202 D\201]1[\000SABR \202D\201]2[";
    xy(100*K,1e2*(DeltaBS[.,1]~Delta1[.,1]~Delta2[.,1])/_sabr_shift_Delta);

    graphprt("-c=1 -cf=hedging10.eps");

  endwind;
