new;
library qam,pgraph,optmum;

cls;

// fn sumr(x) = sumc(x');

Notional = 100;
S0 = 98; mu = 0.10; sigma = 0.20;
tau = 130/260;
r = 0.05;
b = r;
K = 100;
C0 = EuropeanBS(S0,K,sigma,tau,r,r);

Ns = 10000;

sigma = 0.20;

fn Premium_Proc(t,St,rt) = EuropeanBS(St,K,sigma,tau-t,rt,rt);
fn Delta_Proc(t,St,rt) = EuropeanBS_Delta(St,K,sigma,tau-t,rt,rt);

let dt = 26 10 5 2 1;
PnL_Ratio = zeros(Ns,rows(dt));
i = 1;
do until i > rows(dt);
  t = seqa(0,dt[i]/260,130/dt[i]+1);
  St = Simulate_GBM(S0,mu,sigma,t,Ns);
  {Dynamic_Hedging,PnL,PnL_Option,PnL_Hedging,Results} = Compute_Dynamic_Delta_Hedging(Notional,C0,&Premium_Proc,&Delta_Proc,t,St,r,0);
  PnL_Ratio[.,i] = PnL' / (Notional * C0);
  i = i + 1;
endo;

Hedge_Efficiency = stdc(PnL_Ratio);
print dt~Hedge_Efficiency;

x = seqa(-0.30,0.60/255,256);

d = zeros(256,rows(dt));
i = 1;
do until i > rows(dt);
  {d[.,i],F} = regKernelDensity(PnL_Ratio[.,i],x);
  i = i + 1;
endo;
  
graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|3|1; _plwidth = 10; _pcolor = 1|2|3|4|5|6; 
  _pstype = 8|8|8|8|9; _plctrl = 0|0|0|15|15;
  xtics(-30,30,10,2);
  xlabel("\216Ratio \202p\201 (en %)");
  _plegstr = "dt = 26 jours\000dt = 13 jours\000dt = 10 jours\000dt = 5 jours\000dt = 2 jours\000dt = 1 jour";
  _plegctl = {2 5 6 4};
  graphprt("-c=1 -cf=hedging1.eps");
  xy(100*x,d);
