new;
library gdr,pgraph,optmum,option;

rndseed 123;

Notional = 1000;

t_mu = seqa(0,0.10,11);
let mu = 0.00 0.15 0.25 0.30 0.28 0.24 0.20 0.15 0.10 0.05 0.00;

t = seqa(0,0.01,101);
mu = fspline(csspline(t_mu,mu,1,0.9999),t);

/*
graphset;
  xy(t,mu);

let alpha = 0.75 0.90;
ns = 100000;
et = mu' + mu' .* rndn(ns,rows(t));
et = _max_(et,0);

nt = seqa(1,1,rows(t));
PFE = quantile(et,alpha)';
PE = maxc(PFE);
EE = meanc(et);
EPE = cumsumc(EE)./nt;
EEE = zeros(rows(t),1);
EEE[1] = EE[1];
i = 2;
do until i > rows(t);
  EEE[i] = _max_(EEE[i-1],EE[i]);
  i = i + 1;
endo;
EEPE = cumsumc(EEE)./nt;

data = PFE~EE~EPE~EEE~EEPE;

save data;
*/
loadm data;

graphset;
  begwind;
  makewind(9/2,6.855/2,9/4,6.855/2,1);
  makewind(9/2,6.855/2,0,0,1);
  makewind(9/2,6.855/2,9/2,0,1);

  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|1|3; _plwidth = 10; _pcolor = 1|2|4;
  _paxht = 0.25; _pnumht = 0.20; _ptitlht = 0.27;
  xtics(0,1.0,0.20,2);
  xlabel("\216t\201");

  setwind(1);
    title("\216PFE");
    _plegstr = "\202a\201 = 75%\000\202a\201 = 90%";
    _plegctl = {2 5 8.5 2.5};
    m = maxc(data[.,1 2]);     
    _pline = 1~6~0~m[1]~1~m[1]~0~1~10 |
             1~1~0~m[2]~1~m[2]~0~1~10 ;
    m = maxindc(data[.,1 2]);
    m = meanc(t[m]);
    _pline = _pline |
             1~3~m~0~m~1~0~4~10 ;
    xy(t,data[.,1 2]);

  ytics(0,0.4,0.1,2);

  setwind(2);
    _plegstr = "EE\000EPE";
    _plegctl = {2 5 6 4};
    title("\216EE & EPE");
    xy(t,data[.,3 4]);

  setwind(3);
    _plegstr = "EEE\000EEPE";
    _plegctl = {2 5 6 2};
    title("\216EEE & EEPE");
    xy(t,data[.,5 6]);

    graphprt("-c=1 -cf=ccr6.eps");

  endwind;


