new;
library gdr,pgraph,optmum,option;

rndseed 123;

Notional = 1000;

S0 = 100;
K = 100;
Tau = 1;
mu = 0.10;
sigma = 0.20;
r = 0.05;

C0 = EuropeanBS(S0,K,sigma,Tau,r);

nt = 12*20;
t = seqa(0,1/nt,nt+1);

St = simulate_GBM(S0,mu,sigma,t,1);
Ct = EuropeanBS(St,K,sigma,Tau-t,r);

Indx_Months = 1|seqa(nt/12,nt/12,12)+1;
Months = t[Indx_Months];

indx_actual = Indx_Months[7];
t_actual = t[indx_actual];
S_actual = St[Indx_actual];
C_Actual = Ct[Indx_Actual];
MtM_actual = Notional * (C_Actual - C0);

EAD = _max_(Notional * (Ct - C0),0);
EAD = missex(EAD,t .> t_actual);
t_EAD = t;

t = seqa(0,1/48,4*6+1);

St = simulate_GBM(S_actual,r,sigma,t,100000);
Ct = EuropeanBS(St,K,sigma,Tau-(t_actual+t),r)';
MtM_Future = Notional * (Ct - C_Actual);

let alpha = 0.75 0.90;
et = _max_(MtM_Future,0);
nt = seqa(1,1,rows(t));
PFE = quantile(et,alpha)';
PE = maxc(PFE);
EE = meanc(et);
EPE = cumsumc(EE)./nt;
EEE = zeros(rows(t),1);
EEE[1] = EE[1];
i = 2;
do until i > rows(t);
  EEE[i] = _max_(EEE[i-1],EE[i]);
  i = i + 1;
endo;
EEPE = cumsumc(EEE)./nt;

t = 12*(t_actual + t);

_Kernel[1:5] = 0|1e4|256|6|-0.01;
d = zeros(_Kernel[3],rows(t));
i = 2;
do until i > rows(t);
  {x,d[.,i],F,retcode} = Kernel(et[.,i]);
  i = i + 1;
endo;

data = PFE~EE~EPE~EEE~EEPE;
t2 = seqa(6,1/100,601);
data2 = zeros(rows(t2),cols(data));
i = 1;
do until i > cols(data);
  data2[.,i] = fspline(csspline(t,data[.,i],1,0.9999),t2);
  i = i + 1;
endo;
PE = maxc(data[.,1]);

graphset;
  begwind;
  window(2,2,0);

  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|1|3; _plwidth = 10; _pcolor = 1|2|3;
  _paxht = 0.25; _pnumht = 0.20; _ptitlht = 0.27;

  xtics(6,12,1,2);
  xlabel("\216t (en mois)");

  _pzci = 1;
  setwind(1);
    title("\216F]@[t]0[,t@][");
    ytics(0,1e4,0.25e4,2);
    _pzclr = {-0.1 1, 
               2e-5 2,
               6e-5 3,
               1e-4 4,
               1e-3 5};
    ztics(0,0.0015,0.0005,2);
    volume(1.5,1.5,1);
    surface(t',x,d);

  ytics(0,2e4,0.5e4,2);
  ylabel("");

  setwind(2);
    title("\216PFE");
    _plegstr = "\202a\201 = 75%\000\202a\201 = 90%";
    _plegctl = {2 5 1.8 4.20};
    xy(t2,data2[.,1 2]);

  ytics(0,6000,1000,2);

  setwind(3);
    _plegstr = "EE\000EPE";
    title("\216EE & EPE");
    xy(t2,data2[.,3 4]);

  setwind(4);
  _plegstr = "EEE\000EEPE";
    title("\216EEE & EEPE");
    xy(t2,data2[.,5 6]);

    graphprt("-c=1 -cf=ccr5.eps");

  endwind;


