new;
library gdr,pgraph,optmum,option;

rndseed 123;

Notional = 1000;

S0 = 100;
K = 100;
Tau = 1;
mu = 0.10;
sigma = 0.20;
r = 0.05;

C0 = EuropeanBS(S0,K,sigma,Tau,r);

nt = 12*20;
t = seqa(0,1/nt,nt+1);

St = simulate_GBM(S0,mu,sigma,t,1);
Ct = EuropeanBS(St,K,sigma,Tau-t,r);

Indx_Months = 1|seqa(nt/12,nt/12,12)+1;
Months = t[Indx_Months];

indx_actual = Indx_Months[7];
t_actual = t[indx_actual];
S_actual = St[Indx_actual];
C_Actual = Ct[Indx_Actual];
MtM_actual = Notional * (C_Actual - C0);

EAD = _max_(Notional * (Ct - C0),0);
EAD = missex(EAD,t .> t_actual);
t_EAD = t;

t = seqa(0,1/48,4*6+1);

St = simulate_GBM(S_actual,r,sigma,t,100000);
Ct = EuropeanBS(St,K,sigma,Tau-(t_actual+t),r)';
MtM_Future = Notional * (Ct - C_Actual);

EAD_Future = quantile(MtM_Actual + MtM_Future,0.65|0.70|0.75|0.80|0.90)';
w = ones(rows(t),1);
w[1] = 1000;
i = 1;
do until i > cols(EAD_Future);
  EAD_Future[.,i] = fspline(csspline(t,EAD_Future[.,i],1,0.999999),t);
  i = i + 1;
endo;

t_EAD_Future = t_Actual + t;

graphset;
  begwind;
  makewind(9,6.855,0,0,1);
  makewind(9,6.855,0,0,1);
  
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|1|3|5|6; _plwidth = 10; _pcolor = 1|2|3|4|5|6;
  _pstype = 8; _plctrl = 0|0|0|0|1;

  xtics(-1,13,1,0);
  ytics(0,1.0e4,0.2e4,0);
  xlabel("\216t (en mois)");

  setwind(1);
    let xlab = "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12";
    asclabel(xlab,0);
    _pbartyp = {6 3};
//    _parrow =  1.0~1.0~5~1.0~0.9~0.6~1~1~2~3~10;
    bar(12*t_EAD,EaD);

  setwind(2);
    let xlab = "" "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "";
    asclabel(xlab,0);
    _pline = 1~6~6~0~6~1e4~0~0~15;
    _plegstr = "65%\00070%\00075%\00080%\00090%";
    _plegctl = {2 5 6.5 1.5};
    _pmsgstr = "MtM constate\000\202\39\201";
    _pmsgctl = 2.25~6.2~0.15~0~2~0~8|
               3.68~6.23~0.15~0~2~0~8 ;
//    _pline = 1~6~-0.5~0.8e4~5.5~0.8e4~0~0~15;
    _parrow =  1.15~6.0~4.80~6.0~4.0~0.3~02~0~2~3~10;
    xy(12*t_EAD_Future,EaD_Future);

    graphprt("-c=1 -cf=ccr4.eps");

  endwind;

