new;
library gdr,pgraph,optmum,option;

rndseed 123;

Notional = 1000;

S0 = 100;
K = 100;
Tau = 1;
mu = 0.10;
sigma = 0.20;
r = 0.05;

C0 = EuropeanBS(S0,K,sigma,Tau,r);

nt = 12*20;
t = seqa(0,1/nt,nt+1);

St = simulate_GBM(S0,mu,sigma,t,1);
Ct = EuropeanBS(St,K,sigma,Tau-t,r);

Indx_Months = 1|seqa(nt/12,nt/12,12)+1;
Months = t[Indx_Months];

indx_actual = Indx_Months[7];
t_actual = t[indx_actual];
S_actual = St[Indx_actual];
C_Actual = Ct[Indx_Actual];

MtM_actual = Notional * (C_Actual - C0);

t = 1/12|3/12;

St = simulate_GBM(S_actual,r,sigma,t,100000);
Ct = EuropeanBS(St,K,sigma,Tau-(t_actual+t),r)';
MtM_Future = Notional * (Ct - C_Actual);

_Kernel[1:5] = -1e5|1e5|256|6|-C0*Notional;
d = zeros(_Kernel[3],rows(t));
i = 1;
do until i > rows(t);
  {x,d[.,i],F,retcode} = Kernel(MtM_Actual + MtM_Future[.,i]);
  i = i + 1;
endo;

graphset;
  fonts("simplex simgrma");
  _pdate = ""; _pnum = 2; _pframe = 0; 
  _pltype = 6|1|3; _plwidth = 10; _pcolor = 1|2|3;
  _pcross = 1;
  _pline = 1~1~MtM_Actual/1e4~0~MtM_Actual/1e4~10~0~4~10;
  xtics(-2,4,1,2);
  ylabel("");
  xlabel("\216MtM(t)");
  _plegstr = "t = 7 mois\000t = 9 mois";
  _plegctl = {2 5 5 4};
  _pmsgstr = "MtM(t]0[)";
  _pmsgctl = 1.4*MtM_Actual/1e4~1~0.15~0~1~4~8;
  graphprt("-c=1 -cf=ccr3.eps");
  xy(x/1e4,1e5*d);



 

