new;
library gdr,pgraph,optmum,option;

rndseed 123;

Notionel = 1000;

S0 = 100;
K = 100;
Tau = 1;
mu = 0.10;
sigma = 0.20;
r = 0.05;

C0 = EuropeanBS(S0,K,sigma,Tau,r);

nt = 12*20;
t = seqa(0,1/nt,nt+1);

Indx_Months = 1|seqa(nt/12,nt/12,12)+1;
Months = t[Indx_Months];

St = simulate_GBM(S0,mu,sigma,t,1);
Ct = EuropeanBS(St,K,sigma,Tau-t,r);

MtM = Notionel * (Ct[Indx_Months] - C0);

print St[Indx_Months]~Ct[Indx_Months]~MtM;

graphset;
  begwind;
  makewind(9,6.855,0,0,1);
  makewind(9/3,6.855/3,1.5,4.5,1);

  _pdate = ""; _pnum = 2; _pframe = 0;

  setwind(1);
    _pbartyp = {6 3};
    xtics(-1,13,1,0);
    ylabel("\216MtM");
    xlabel("\216t (en mois)");
    bar(seqa(0,1,13),MtM);

  setwind(2);
    _pltype = 3; _plwidth = 10; _pcolor = 1; _pbox = 1;
    _paxht = 0.30; _pnumht = 0.22; _ptitlht = 0.30;
    xtics(0,1,0.20,0);
    ytics(90,120,10,2);
    xlabel("\216t");
    ylabel("");
    title("\216S(t)");
    xy(t,St);

    graphprt("-c=1 -cf=ccr2.eps");

  endwind;


