new;
library gdr,pgraph;
gdrSet;

datFileName = "index"; 
data = loadd(datFileName);
vnames = "" $+ getname(datFileName);
let selected_names = date cac;
indx = indsav(selected_names,vnames);
data = data[.,indx];

Dates = data[.,1];
nDates = rows(Dates);
CaC = data[.,2];

nDates = rows(Dates);
Nominal = 1e6;

Rdt = CaC./lag1(CAC) - 1;

let Length = 250 500 750;
nLength = rows(Length);

VaR = miss(zeros(nDates,nLength),0);

alpha = 0.99;

i = 1;
do until i > nDates;

  j = 1;
  do until j > nLength;
    if i-length[j] < 1;
      j = j + 1;
      continue;
    endif;
    VaR[i,j] = -quantile(Rdt[i:i-length[j]],1-alpha);
    j = j + 1;
  endo;

  i = i + 1;
endo;

VaR = Nominal * VaR;
Loss = -Nominal * lagn(Rdt,-1);
nEx = miss(zeros(nDates,nLength),0);

i = 251;
do until i > nDates;
  BT = Loss[i:i-250,.] .>= VaR[i:i-250,.];
  nEx[i,.] = sumc(BT)';
  i = i + 1;
endo;

nEx = selif(nEx,Dates .>= 19900101);
Dates = selif(Dates,Dates .>= 19900101);

end;

t = seqa(1,5,rows(nEx)/5);

nEx = nEx[t,.];

graphset;
  begwind;
  makewind(9/2,6.855/2,9/4,6.855/2,1);
  makewind(9/2,6.855/2,0,0,1);
  makewind(9/2,6.855/2,9/2,0,1);

  _pdate = ""; _pnum = 2; _pframe = 0;
  _pltype = 6|1|3; _plwidth = 10; _pcolor = 1|2|3;
  _ptitlht = 0.30; _pnumht = 0.21;
  xtics(1,52*20,2*52,1);
  let xlab = "92" "94" "96" "98" "2000" "02" "04" "06" "08" "10";
  asclabel(xlab,0);

  ytics(0,12,2,1);
  
  setwind(1);
    _pbartyp = 6~1;
    title("\2161 an");
    bar(0,nEx[.,1]);

  setwind(2);
    _pbartyp = 6~2;
    title("\2162 ans");
    bar(0,nEx[.,2]);

  ytics(0,18,2,1);

  setwind(3);
    _pbartyp = 6~4;
    title("\2163 ans");
    bar(0,nEx[.,3]);

    graphprt("-c=1 -cf=var19.eps");

  endwind;


